<?php
include 'db.php'; 

$purchase_id = $_GET['purchase_id'] ?? null;

// Check if purchase_id is provided
if (!$purchase_id) {
    echo json_encode(["status" => "error", "message" => "Purchase ID is required"]);
    exit;
}

// Sanitize input
$purchase_id = mysqli_real_escape_string($conn, $purchase_id);

// Query the `purchase` table to get purchase data
$purchase_query = "
    SELECT 
        pu.*, 
        c.phoneno,
        c.address,
        c.city,
        c.state,
        c.pincode,
        COALESCE(SUM(p.Payment_amount), 0) AS customerpaid
    FROM 
        purchase pu
    LEFT JOIN 
    customer c ON pu.vendor_id = c.id
    LEFT JOIN 
        payment p ON pu.purchase_id = p.purchase_id
    WHERE 
        pu.Delete_status = 0 
        AND pu.purchase_id = '$purchase_id'
    GROUP BY 
        pu.purchase_id
    ORDER BY 
        pu.Created_date DESC
";

$purchase_result = mysqli_query($conn, $purchase_query);

if ($purchase_result && mysqli_num_rows($purchase_result) > 0) {
    $purchase = mysqli_fetch_assoc($purchase_result);
    
    // Fetch purchase data for the particular purchase
    $purchase_data_query = "
        SELECT * FROM purchase_data
        WHERE purchase_id = '$purchase_id' AND Delete_status = 0
    ";

    $purchase_data_result = mysqli_query($conn, $purchase_data_query);
    
    $purchase_data = [];
    if ($purchase_data_result && mysqli_num_rows($purchase_data_result) > 0) {
        while ($data = mysqli_fetch_assoc($purchase_data_result)) {
            $purchase_data[] = $data;
        }
    }

    // Fetch payment details
    $paymentsQuery = "
        SELECT
            pc.Payment_date,
            pc.Payment_type,
            pc.Amount
        FROM
            payment pc
        WHERE
            pc.purchase_id = '$purchase_id';
    ";
    
    $paymentResult = mysqli_query($conn, $paymentsQuery);

    $payments = [];
    if ($paymentResult && mysqli_num_rows($paymentResult) > 0) {
        while ($row = mysqli_fetch_assoc($paymentResult)) {
            $payments[] = [
                'paymentdate' => htmlspecialchars($row['Payment_date']),
                'paymenttype' => htmlspecialchars($row['Payment_type']),
                'amount' => htmlspecialchars($row['Amount']),
            ];
        }
    }

    // Add purchase data and payment details to the purchase
    $purchase['purchase_data'] = $purchase_data;
    $purchase['payment'] = $payments;

    // Return success and the purchase data
    $response = [
        'status' => "success",
        'message' => "Purchase fetched successfully",
        'data' => $purchase
    ];
} else {
    $response = [
        'status' => "error",
        'message' => "Purchase not found for this user"
    ];
}

// Return the response as JSON
header('Content-Type: application/json');
echo json_encode($response);
?>
